/*
* accessibility overlay element
*/

$(document).ready(function(){
  var $html         = $('html');
  var $component 	  = $('[data-js-accessibilityoverlay]');
  var $buttonToggle = $('[data-js-accessibilityoverlay-toggle]');
  var $buttonClose  = $('[data-js-accessibilityoverlay-close]');
  var $overlay      = $('[data-js-accessibilityoverlay-overlay]');
  var $option       = $('[data-js-accessibilityoverlay-option]');
  var storedOptions = JSON.parse(localStorage.getItem('accessibility')) || [];
  var $pageOriginFocus; // a11y

  if (!$component.length) return;

  var fnInit = function(){
    fnRestoreStoredOptions();
    fnApplyAndSaveState();
    fnRestoreOptionStates();
    observeInteractions();
  };

  var fnRestoreStoredOptions = function(){
    var htmlOptions = $html.attr('data-a11y') ? $html.attr('data-a11y').replace(/\s/g, '') : false;
    htmlOptions = htmlOptions.length ? htmlOptions.split(',') : [];
    
    function merge(array1, array2) {
      for (let i=0; i<array2.length; i++) {
        if (array1.indexOf(array2[i])==-1) array1.push(array2[i]);
      }
      return array1;
    }

    storedOptions = merge(storedOptions, htmlOptions);
  };

  var fnApplyAndSaveState = function(){
    $html.attr('data-a11y', storedOptions);
    localStorage.setItem('accessibility', JSON.stringify(storedOptions));

    fnApplySpecialStates();
  };

  var fnApplySpecialStates = function(){
    if (storedOptions.indexOf('a11y-animation--off') !== -1) {
      $('video').each(function() { this.pause(); });
    } else {
      $('video[autoplay]').each(function() { if (this.paused) this.play(); });
    }
  };

  var fnRestoreOptionStates = function(){
    $option.each(function(){
      var $this = $(this);
      var value = $this.val();
      var optionIsStored = storedOptions.indexOf(value) !== -1;

      if(optionIsStored) {
        $this.addClass('is-active');
      }
    });
  };

  var observeInteractions = function(){
    $option.on('click', function(){
      var $this = $(this);
      var value = $this.val();
      var optionIsActive = $this.hasClass('is-active');

      if(!optionIsActive) {
        $this.addClass('is-active');
        fnAddState(value);
      } else {
        $this.removeClass('is-active');
        fnRemoveState(value);
      }
    });

    $buttonToggle.on('click', function(event){
      event.preventDefault();
      if (isOverlayOpened()) {
        fnCloseOverlay(); 
      } else {
        fnOpenOverlay();
      }
    });

    $buttonClose.on('click', function(event){
      event.preventDefault();
      fnCloseOverlay();
    });

    $(document).on('keyup',function(event) {
      if(event.keyCode == 27) { // ESC
        if (isOverlayOpened()) fnCloseOverlay();
      }
    });
  };

  var fnAddState = function(value){
    storedOptions.push(value);
    fnApplyAndSaveState();
  };

  var fnRemoveState = function(value){
    storedOptions.splice(storedOptions.indexOf(value), 1);
    fnApplyAndSaveState();
  };

  var isOverlayOpened = function() { return $component.hasClass('is-active'); }

  var fnOpenOverlay = function() {
    $pageOriginFocus = $(':focus'); // a11y
    $component.addClass('is-active');
    fnSetOverlayFocus(); // a11y
  }

  var fnCloseOverlay = function() {
    $component.removeClass('is-active');
    fnSetPageFocus(); // a11y
  }

  var fnSetOverlayFocus = function(){ // a11y
    $overlay[0].inert = false;
    setTimeout(function(){
      $buttonClose.first().focus();
    }, 100); // need to wait for $transition-time-short
  }

  var fnSetPageFocus = function(){ // a11y
    $overlay[0].inert = true;
    if ($pageOriginFocus) {
      $pageOriginFocus.focus();
      $pageOriginFocus = false;
    }
  }

  fnInit();
});
