/*
* accessibility skip feature
* - feature to set focus to specific elements
*/

$(document).ready(function(){
  var $a11ySkip = $('[data-js-a11y-skip]');
  var focusableElements = GLOBALS.focusableElements;

  $a11ySkip
    .off() // turn off scrollto.js
    .on('click', function(e){
      e.preventDefault();

      var selector = $(this).attr("href");
      var $target = $(selector);
      if (!$target.length) return;

      $target.focus();
      
      var targetHasFocus = $target.is(":focus");

      if (!targetHasFocus) {
        var $firstFocusableElement = $target.find(focusableElements).eq(0);
        $firstFocusableElement.focus();
      }

  });
});
