/*
* cookie crud template
*/

$(document).ready(function(){
	var component = {
		elements: {
			$component: $('[data-js-component]'),
		},
		defaults: {
			views: 0,
			accepted: false,
		},
		data: null,
		maxViews: 1,
	};
	
	component.init = function(){
		component.setData();
		component.setVisibility();
	};
	
	component.setData = function(){
		var cookieData = Cookies.getJSON('component');
		component.data = $.extend({}, component.defaults, cookieData);
	};
	
	component.setVisibility = function(){
		component.data.views += 1;
		if (component.data.views > component.maxViews || component.data.accepted) {
			component.hideComponent();
		} else {
			component.showComponent();
			component.observeInteraction();
		}
		component.updateData();
	};
	
	component.hideComponent = function(){
		component.elements.$component.remove();
	};
	
	component.showComponent = function(){
		component.elements.$component
			.prependTo(component.elements.$prependTo)
			.show();
	};
	
	component.observeInteraction = function(){
		component.elements.$componentClose.on('click', function(){
			component.hideComponent();
			component.data.accepted = true;
			component.updateData();
		});
	};
	
	component.updateData = function(){
		Cookies.set('component', component.data);
	};
	
	component.init();
});