/*
* count feature
*/

function countToValue(element, start = 0, end = null, duration = 1500) {
    if (!element) return;

    const originalText = element.innerHTML;
    end = end ?? parseInt(originalText.replace(/\D/g, ""), 10);
    if (isNaN(end)) return;

    const range = end - start;
    if (range === 0) return;

    const minTimer = 50;
    const steps = Math.ceil(duration / minTimer);
    let currentStep = 0;

    // easing function for smoother animation
    function easeOutQuad(t) {
        return t * (2 - t);
    }

    function run() {
        currentStep++;
        const progress = easeOutQuad(Math.min(currentStep / steps, 1));
        const currentValue = Math.round(start + range * progress);

        element.innerHTML = originalText.replace(
            /([0-9]+)/g,
            currentValue.toLocaleString('de-DE') // adds dot for numbers like 1.234
        );

        if (currentStep >= steps) {
            clearInterval(timer);
        }
    }

    const timer = setInterval(run, minTimer);
    run();
}

document.addEventListener("DOMContentLoaded", () => {
    const selector = '[data-js-count]';
    const rootMargin = '40px 0px -40px 0px';
    const elements = document.querySelectorAll(selector);

    if (!('IntersectionObserver' in window)) {
        elements.forEach(el => countToValue(el));
        return;
    }

    const observer = new IntersectionObserver((entries, obs) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                countToValue(entry.target);
                obs.unobserve(entry.target);
            }
        });
    }, { rootMargin });

    elements.forEach(el => observer.observe(el));
});
