/*
* layer
* - use cases: cta, page load, page load timed, url parameter
*/

var LAYER = (function(){
  var $document,
      $html,
      $layer,
      $layerContent,
      $layerClose,
      $layerOpener,
      $pageOriginFocus;

  var layerSource   = '[data-js-layer-source]';
  var layerOpen     = 'is-layer-open';
  var layerLoading  = 'is-layer-loading';

  var fnInit = function(){
    fnGetElements();
    fnObserveInteraction();
  };

  var fnGetElements = function(){
    $document     = $(document);
    $html         = $('html');
    $layer        = $('[data-js-layer]');
    $layerContent = $('[data-js-layer-content]');
    $layerClose   = $('[data-js-layer-close]');
    $layerOpener  = $('[data-js-layer-open]');
  };

  var fnObserveInteraction = function(){
    $layerOpener.on('click', fnOpenerClick);

    $layerClose.on('click', function(event){
      event.preventDefault();
      fnCloseLayer();
    });

    // a11y
    $document.on('keyup',function(event){
      if (event.keyCode == 27){ // ESC
        fnCloseLayer();
      }
    });
  };

  var fnOpenerClick = function(event){
    event.preventDefault();

    $pageOriginFocus = $(':focus'); // a11y

    var $opener = $(this);
    var url = $opener.attr('href');

    fnOpenWithUrl(url);
  };

  var fnOpenWithUrl = function(url){
    fnShowLoading();
    fnOpenLayer();

    $.ajax({
      url: url,
      type: "GET",
      dataType : "html",
      success: fnProcessData,
    });
  };

  var fnShowLoading = function(){
    $html.addClass(layerLoading);
  };

  var fnOpenLayer = function(){
    $html.addClass(layerOpen);
  };

  var fnProcessData = function(data){
    var $ajaxHtml = $(data);
    var $ajaxContent = $ajaxHtml.find(layerSource);

    fnHideLoading();

    fnSetLayerFocus(); // a11y

    $layerContent
      .empty()
      .append($ajaxContent);
  };

  var fnHideLoading = function(){
    $html.removeClass(layerLoading);
  };

  var fnSetLayerFocus = function(){ // a11y
    $layer[0].inert = false;
    $layerClose.last().focus();
  }

  var fnCloseLayer = function(){
    $html.removeClass(layerOpen);
    fnSetPageFocus(); // a11y
  };

  var fnSetPageFocus = function(){ // a11y
    $layer[0].inert = true;
    if ($pageOriginFocus) {
      $pageOriginFocus.focus();
      $pageOriginFocus = false;
    }
  }

  return {
    fnInit        : fnInit,
    fnOpenWithUrl : fnOpenWithUrl,
  };
})();

$(document).ready(function(){
  LAYER.fnInit();
});
