/*
* offcanvas module
*/

$(document).ready(function(){
    var $html               = $('html');
    var $offcanvas          = $('[data-js-offcanvas]'); // a11y
    var $offcanvasClose     = $('[data-js-offcanvas-close]');
    var $offcanvasToggle    = $('[data-js-offcanvas-toggle]');
    var $offcanvasSubmenu   = $('[data-js-offcanvas]').find("a.submenu");
    var $offcanvasAnchor    = $('[data-js-offcanvas]').find('a[href*="#"]:not([href="#"])');
    var offcanvasOpen       = 'is-offcanvas-open';
    var animationDuration   = 600 * 1.5; // matches vars: $transition-time-medium
    var $pageOriginFocus;   // a11y

    if (!$offcanvasToggle.length) return;

    var isOffcanvasOpened = function() { return $html.hasClass(offcanvasOpen); }

    var fnCloseOffcanvas = function() {
        $html.removeClass(offcanvasOpen);
        fnSetPageFocus(); // a11y
    }

    var fnOpenOffcanvas = function(offcanvasSubmenuTarget) {
        $pageOriginFocus = $(':focus'); // a11y
        $html.addClass(offcanvasOpen);
        fnSetOffcanvasFocus(); // a11y

        if (offcanvasSubmenuTarget) {
            var $offcanvasSubmenuMatch = $offcanvasSubmenu.filter(function() {
                return $(this).text().trim() === offcanvasSubmenuTarget;
            });
            setTimeout(function(){
                $offcanvasSubmenuMatch.focus().trigger('open');
            }, animationDuration);
        }
    }

    var fnSetPageFocus = function(){ // a11y
        $offcanvas[0].inert = true;
        if ($pageOriginFocus) {
          $pageOriginFocus.focus();
          $pageOriginFocus = false;
        }
    }

    var fnSetOffcanvasFocus = function(){ // a11y
        $offcanvas[0].inert = false;
        $offcanvas.find($offcanvasToggle).focus();
    }

    // a11y
    $(document).on('keyup',function(event) {
        if (event.keyCode == 27) { // ESC
            if (isOffcanvasOpened()) fnCloseOffcanvas();
        }
    });

    $offcanvasClose.on('click', function(event) {
        event.preventDefault();
        fnCloseOffcanvas();
    });

    $offcanvasToggle.on('click', function(event) {
        event.preventDefault();
        var offcanvasSubmenuTarget = $(this).attr('data-js-offcanvas-toggle');
        if (isOffcanvasOpened()) {
            fnCloseOffcanvas();
        } else {
            fnOpenOffcanvas(offcanvasSubmenuTarget);
        }
    });
    
    /*
     * get all links containing # (but not only #), and check if existent on page
     * - when not, return and follow link
     * - if so, execute scrollTo
    */
    $offcanvasAnchor.on("click", function(event){
        var href = $(this).attr("href");
        var selector = '#' + href.split('#')[1];

        var targetExistsOnCurrentPage = $(selector).length;
        if (!targetExistsOnCurrentPage) return;
        
        fnCloseOffcanvas();

        /*
         * scrollto.js then fires:
         * - event.preventDefault();
         * - GLOBALS.function.scrollTo(selector);
         */
    });
});

// offcanvas accordion
$(document).ready(function(){
    var $offcanvas          = $('[data-js-offcanvas]');
    var $offcanvasSubmenu   = $offcanvas.find("a.submenu");
    var animationDuration   = 300;

    if (!$offcanvasSubmenu.length) return;

    var fnToggleSubmenu = function(event) {
        event.preventDefault();
        var $list = $(this).next();
        $list.stop().slideToggle(animationDuration);
    }

    var fnOpenSubmenu = function(event) {
        event.preventDefault();
        var $list = $(this).next();
        $list.stop().slideDown(animationDuration);
    }

    $offcanvasSubmenu.on('click', fnToggleSubmenu);
    $offcanvasSubmenu.on('open', fnOpenSubmenu);
});
