/*
 * quicklinks image swap
 */

document.addEventListener("DOMContentLoaded", () => {
  const quicklinkBlocks = document.querySelectorAll(".c-quicklinks");

  quicklinkBlocks.forEach(quicklinkBlock => {
    const parent = quicklinkBlock.parentElement;
    if (!parent) return;

    const sibling = parent.previousElementSibling || parent.nextElementSibling;
    if (!sibling) return;

    const image = sibling.querySelector("img");
    if (!image) return;

    const originalSrc = image.getAttribute("src");

    quicklinkBlock.querySelectorAll("[data-img]").forEach(link => {
      const hoverSrc = link.getAttribute("data-img");
      if (!hoverSrc) return;

      link.addEventListener("mouseenter", () => {
        image.setAttribute("src", hoverSrc);
      });
    });

    quicklinkBlock.addEventListener("mouseleave", () => {
      image.setAttribute("src", originalSrc);
    });
  });
});
