/*
* scroll direction feature
*/

(function(){
	var lastScrollTop = 0, delta = 40;
	var $html = $("html");

	$(window).scroll(function(){
		var nowScrollTop = $(this).scrollTop();

		if(nowScrollTop > 0){
			$html.addClass("is-scrolled");
		} else {
			$html.removeClass("is-scrolled");
		}

		if(nowScrollTop > delta){
			$html.addClass("is-scrolled-delta");
		} else {
			$html.removeClass("is-scrolled-delta");
		}

		if(Math.abs(lastScrollTop - nowScrollTop) >= delta){
			if (nowScrollTop > lastScrollTop){
				$html.addClass("is-scrolldown");
			} else {
				$html.removeClass("is-scrolldown");
			}

			lastScrollTop = nowScrollTop;
		}
	});
})();