/*
* scroll to plugin
*/

/*
 * create global scrollto function
*/
$(document).ready(function(){
	GLOBALS.function.scrollTo = function(targetSelectorOrElement, customOffset) {
		var $target = $(targetSelectorOrElement);
		if (!$target.length) return;

		var interactionDelay = 100;
		var targetPadding = parseInt($target.css('paddingTop'));
		var targetMargin = parseInt($target.css('marginTop'));
		var targetOffset = targetPadding ? 0 : targetMargin;
		var headerOffset = GLOBALS.layout.header.isSticky ? 80 + 40 : 0; // header height + buffer
		var customOffset = customOffset ? customOffset : 0;
		var scrollPosition = $target.offset().top - (targetOffset + 1) - headerOffset - customOffset;
		
		setTimeout(function(){
			$('html, body').animate({ scrollTop: scrollPosition }, 'slow');
		}, interactionDelay);

		$target.focus(); // a11y
	}
});

/*
 * use scrollto function on pageload
*/
if (window.location.hash) {
	/*
	 * we need to scroll to the top of the window first, because the browser will always jump to the anchor first before JavaScript is ready,
	 * thanks Stack Overflow: http://stackoverflow.com/a/3659116
	 */
	setTimeout(function() {
		window.scrollTo(0, 0);

		$(document).ready(function(){
			window.scrollTo(0, 0);
			var selector = window.location.hash;
			GLOBALS.function.scrollTo(selector);
		});
	}, 1);
}

/*
 * use scrollto function for
 * - links containing #
 * - links having data-js-scrollto to use with class names instead of ids
*/
$(document).ready(function(){
	var $anchorClassLink = $('[data-js-scrollto]');
	$anchorClassLink.on("click", function(event){
		event.preventDefault();
		var selector = $(this).attr("href");
		GLOBALS.function.scrollTo(selector);
	});
	
	/*
	 * get all links containing # (but not only #), and check if existent on page
	 * - when not, return and follow link
	 * - if so, execute scrollTo
	*/
	var $anchorHashLink = $('a[href*="#"]:not([href="#"])');
	$anchorHashLink.on("click", function(event){
		var href = $(this).attr("href");
		var selector = '#' + href.split('#')[1];

		var targetExistsOnCurrentPage = $(selector).length;
		if (!targetExistsOnCurrentPage) return;

		event.preventDefault();
		GLOBALS.function.scrollTo(selector);
	});
});

/*
 * use scrollto function for
 * - form errors
*/
$(document).ready(function(){
	var $formError		= $('form .error').first().closest('form');
	var $formConfirm 	= $('form .confirm').first().closest('form');

	if ($formError.length)	 GLOBALS.function.scrollTo($formError, 50);
	if ($formConfirm.length) GLOBALS.function.scrollTo($formConfirm, 50);
});
