/*
* edge slider
*/

var SLIDEREDGE = (function(){
  var $slider,
      $stage,
      $slides,
      $ctaPrev,
      $ctaNext,
      $textCurrent;

  var slideStateActive        = 'is-slide-active';
  var slideStateFadeout       = 'is-slide-fadeout';
  var slideTransitionInstant  = 'is-slide-instant';

  var fnInit = function(){
    fnGetElements();
    fnObserveInteraction();
    fnSetupSplashScreen();
  };

  var fnGetElements = function(){
    $slider       = $('[data-js-slideredge]');
    $stage        = $slider.find('[data-js-slideredge-stage]');
    $slides       = $stage.find('> *:not(:nth-child(1))');
    $ctaPrev      = $slider.find('[data-js-slideredge-prev]');
    $ctaNext      = $slider.find('[data-js-slideredge-next]');
    $textCurrent  = $slider.find('[data-js-slideredge-current]');
  };

  var fnObserveInteraction = function(){
    $slides.on('click', fnOpenSlide);
    $ctaPrev.on('click', fnPaginationPrev);
    $ctaNext.on('click', fnPaginationNext);
  };

  var fnOpenSlide = function(event){
    var $slide = $(this);
    var alreadyActiveSlide = $slide.hasClass(slideStateActive);

    fnSlidesCloseAll();
    if (!alreadyActiveSlide) $slide.addClass(slideStateActive);

    fnPaginationUpdate();
  };

  var fnSlidesCloseAll = function(event){
    $slides.removeClass(slideStateActive);
  };

  var fnPaginationPrev = function(){
    var indexCurrent  = $slides.filter('.'+slideStateActive).index();
    var childCurrent  = indexCurrent - 1;
    var childNew      = childCurrent - 1;
    var $slidePrev    = $slides.eq(childNew);

    if(childNew < 0) $slidePrev = null;
    if(childNew < 0 && childCurrent < 0) $slidePrev = $slides.eq(2);

    fnOpenSlide.call($slidePrev);
  };

  var fnPaginationNext = function(){
    var indexCurrent  = $slides.filter('.'+slideStateActive).index();
    var childCurrent  = indexCurrent - 1;
    var childNew      = childCurrent + 1;
    var $slidePrev    = $slides.eq(childNew);

    if(childNew > 2) $slidePrev = null;
    if(childNew < 0 && childCurrent < 0) $slidePrev = $slides.eq(0);

    fnOpenSlide.call($slidePrev);
  };

  var fnPaginationUpdate = function(){
    var current = $slider.find('.'+slideStateActive).index();
    current = current < 0 ? 0 : current;
    $textCurrent.text(current);
  };

  var fnSetupSplashScreen = function($slide){
    $slides.addClass(slideTransitionInstant);

    $slideFirst = $slides.eq(0);
    $slideFirst.addClass(slideStateActive);

    $slidesOther = $slides.not($slides.eq(0));
    $slidesOther.addClass(slideStateFadeout);

    setTimeout(function(){
      $slides.removeClass(slideTransitionInstant);

      setTimeout(function(){
        $slideFirst.removeClass(slideStateActive);
        $slidesOther.removeClass(slideStateFadeout);
        fnPaginationUpdate();
      }, 2000);
    }, 0);
  };

  return {
    fnInit : fnInit,
  };
})();

$(document).ready(function(){
  SLIDEREDGE.fnInit();
});
