/*
* slick slider
* - uses slick.js plugin
*/

$(document).ready(function(){
  var $slickSlider = $('[data-js-slick]');

  $slickSlider.each(function(){
    var $this = $(this);
    var slickConfig;

    var init = function(){
      setMarkup();
      setConfig();
      runSlider();
    };

    var setMarkup = function(){
      $this.children().first().addClass('is-first');
      $this.children().last().addClass('is-last');
    };

    var setConfig = function(){
      var slickOptions = $this.data('js-slick');
      slickOptions = slickOptions.split(',');

      var getNavReferenceSlider = function(){ 
        var navReferenceSlider = $this.parent().parent().next().find('[data-js-slick]');
        navReferenceSlider = navReferenceSlider.length ? navReferenceSlider : $this.parent().parent().prev().find('[data-js-slick]');
        return navReferenceSlider.length ? navReferenceSlider : null;
      };
      
      var slidesToShow = parseInt(slickOptions[2]);

      slickConfig = {
        autoplay:      slickOptions[0] != 0,
        autoplaySpeed: slickOptions[1] != 0 ? parseInt(slickOptions[1]) : 2000,
        asNavFor:      getNavReferenceSlider(),
        slidesToShow:  slickOptions[2] != 0 ? slidesToShow : 1,
        slidesToScroll:slickOptions[2] != 0 ? slidesToShow : 1,
        infinite:      slickOptions[3] != 0,
        dots:          slickOptions[4] != 0,
        arrows:        slickOptions[5] != 0,
        centerMode:    slickOptions[6] != 0 && slidesToShow % 2 == 1,
        centerPadding: parseInt(slickOptions[7])+'px',
        speed:         1500,
        responsive:    slickOptions[2] > 1 ? [{ // TODO: set responsive config via custom fields
            breakpoint: GLOBALS.breakpoint.xl,
            settings: {
              slidesToShow: slidesToShow - 1 > 0 ? slidesToShow - 1 : 1,
              slidesToScroll: slidesToShow - 1 > 0 ? slidesToShow - 1 : 1,
              centerMode: slickOptions[6] != 0 && (slidesToShow - 1) % 2 == 1,
            },
          },{
            breakpoint: GLOBALS.breakpoint.lg,
            settings: {
              slidesToShow: slidesToShow - 2 > 0 ? slidesToShow - 2 : 1,
              slidesToScroll: slidesToShow - 2 > 0 ? slidesToShow - 2 : 1,
              centerMode: slickOptions[6] != 0 && (slidesToShow - 2) % 2 == 1,
            },
          },{
            breakpoint: GLOBALS.breakpoint.md,
            settings: {
              slidesToShow: slidesToShow - 3 > 0 ? slidesToShow - 3 : 1,
              slidesToScroll: slidesToShow - 3 > 0 ? slidesToShow - 3 : 1,
              centerMode: slickOptions[6] != 0 && (slidesToShow - 3) % 2 == 1,
            },
          }] : [],
      };
    };

    var getPagingMarkup = function(slideCount, currentCount, fillDuration){
      var markup =
        // '<div class="slick-dot-count">'+currentCount+'/'+slideCount+'</div>'+
        '<div class="slick-dot-click">'+
          '<div class="slick-dot-line">'+
            '<span class="slick-dot-fill" style="animation-duration:'+fillDuration+'ms"></span>'+
          '</div>'+
        '</div>';
      return markup;
    };

    var runSlider = function(){
      $this.slick({
        arrows: slickConfig.arrows,
        autoplay: slickConfig.autoplay,
        autoplaySpeed: slickConfig.autoplaySpeed,
        asNavFor: slickConfig.asNavFor,
        centerMode: slickConfig.centerMode,
        centerPadding: slickConfig.centerPadding,
        dots: slickConfig.dots,
        infinite: slickConfig.infinite,
        slidesToScroll: slickConfig.slidesToScroll,
        slidesToShow: slickConfig.slidesToShow,
        nextArrow: '<button type="button" aria-label="Weiter" class="slick-arrow--next"><span class="fas fa-angle-right"></span></button>',
        prevArrow: '<button type="button" aria-label="Zurück" class="slick-arrow--prev"><span class="fas fa-angle-left"></span></button>',
        pauseOnFocus: false,
        pauseOnHover: false,
        speed: slickConfig.speed,
        customPaging: function(slider, currentCount) {
          var fillDuration = slickConfig.autoplaySpeed + slickConfig.speed - 100;
          return getPagingMarkup(slider.slideCount, currentCount+1, fillDuration);
        },
        responsive: slickConfig.responsive,
      }).slick("slickPause");

      if (slickConfig.autoplay) {
        var initialDelay = slickConfig.speed;
        setTimeout(function() {
          $this.slick("slickPlay");
        }, initialDelay);
      }
    };

    init();
  });
});
