/*
* fit section text
*/

document.addEventListener("DOMContentLoaded", () => {
  const textBlocks = document.querySelectorAll(".c-text--fitSection");

  textBlocks.forEach(textEl => {
    const col = textEl.closest('[class*="col-"]');
    if (!col) return;

    const siblingCol = col.previousElementSibling || col.nextElementSibling;
    if (!siblingCol) return;

    const image = siblingCol.querySelector("img");
    if (!image) return;

    const clampText = () => {
      // Reset Zustand
      textEl.classList.remove("is-clamped", "is-expanded");
      textEl.style.removeProperty("--clamp-height");

      const oldBtn = textEl.querySelector(".o-text-link");
      if (oldBtn) oldBtn.remove();

      const isMobile = window.innerWidth < GLOBALS.breakpoint.md;
      if (isMobile) return;

      const textHeight = textEl.scrollHeight;
      const imageColHeight = siblingCol.offsetHeight;
      const heightTolerancePx = 24;

      if (textHeight > imageColHeight + heightTolerancePx) {
        textEl.classList.add("is-clamped");
        textEl.style.setProperty('--clamp-height', imageColHeight + 'px');

        const btn = document.createElement("button");
        btn.classList.add("o-text-link");
        btn.textContent = TRANSLATIONS[GLOBALS.lang].showMore;

        btn.addEventListener("click", () => {
          const expanded = textEl.classList.toggle("is-expanded");
          btn.textContent = expanded ? TRANSLATIONS[GLOBALS.lang].showLess : TRANSLATIONS[GLOBALS.lang].showMore;
        });

        textEl.appendChild(btn);
      }
    };

    // Wenn das Bild schon geladen ist, sofort clampen – sonst auf load warten
    if (image.complete) {
      clampText();
    } else {
      image.addEventListener("load", clampText);
    }

    // Neu prüfen bei Resize
    window.addEventListener("resize", clampText);
  });
});