/*
* theme switcher
*/

$(document).ready(function(){
  var $html   		= $('html');
  var $switcher 	= $('[data-js-themeswitcher]');
  var $switch 		= $('[data-js-themeswitch]');
  var storedTheme = localStorage.getItem('theme');
  var timer				= null;

  $html.attr('data-theme', storedTheme);

  var toggleHoverState = function(){
  	clearTimeout(timer);
  	$switcher.addClass('is-hover');
  	timer = setTimeout(function(){
  		$switcher.removeClass('is-hover');
  	}, 3000);
  }

  var toggleThemeState = function(newTheme){
    storedTheme = newTheme !== storedTheme ? newTheme : '';    
    $html.attr('data-theme', storedTheme);
    localStorage.setItem('theme', storedTheme);
  }

  $switch.on('click', function(e){
    e.preventDefault();
    var newTheme = $(this).attr('data-js-themeswitch');
  	toggleThemeState(newTheme);
    // toggleHoverState();
  });

  var urlObject = new URL(window.location.href);
  var urlParam = urlObject.searchParams.get('themeswitch');
  if (urlParam) {
    $switch
      .filter('[data-js-themeswitch='+urlParam+']')
      .trigger('click');
  }
});
