/*
* type feature
* - uses type.js plugin
*/

$(document).ready(function(){
	$('[data-js-type]').each(function(){
		var $this = $(this);
		// get config
		var config = $this.data('js-type');
		var configDelay = parseInt(config) > 0 ? parseInt(config) : 1000;
		// get type strings
		var typeStrings = $this.html();
		var typeStringsArray = typeStrings.split('|');
		// prepare markup
		$this.text('').append('<span></span>');
		// start animation
		var typeAnimation = new Typed(this.childNodes[0], {
			strings: typeStringsArray,
			cursorChar: '_',
			typeSpeed: 20,
			backSpeed: 20,
			backDelay: 2000,
			startDelay: configDelay,
			loop: false,
		});
	});
});
