<?php

namespace App\EventListener;

use Contao\CoreBundle\Event\ContaoCoreEvents;
use Contao\CoreBundle\Event\MenuEvent;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;

#[AsEventListener(ContaoCoreEvents::BACKEND_MENU_BUILD, priority: -255)]
class ThemeConfiguratorMenuListener
{
    public function __invoke(MenuEvent $event): void
    {
        $tree = $event->getTree();

        if ('mainMenu' !== $tree->getName()) {
            return;
        }

        $factory = $event->getFactory();
        $contentNode = $tree->getChild('design');

        // add menu entry to main menu
        $node = $factory
            ->createItem('theme_configurator_module', [
                'uri' => 'contao?do=themes&id=26&table=tl_module&act=edit',
            ])
            ->setLabel('Theme Konfigurator')
            ->setLinkAttribute('title', 'Springt direkt zum Modul für Design+ Theme Konfigurationen')
            ->setLinkAttribute('target', '_self');

        $contentNode->addChild($node);
    }
}
