<?php

namespace App\EventListener;

use Contao\CoreBundle\ServiceAnnotation\Callback;

/**
 * @Callback(table="tl_content", target="config.onload")
 */
class TlContentListener
{
    public function __invoke(): void
    {
        $forbidden = [
            'toplink', 'vimeo',
            'teaser',
            'template',
            'sliderStart', 'sliderStop',
            'dma_simplegrid_row_start', 'dma_simplegrid_row_stop',
            'dma_simplegrid_column_start', 'dma_simplegrid_column_stop',
        ];

        foreach ($GLOBALS['TL_CTE'] as $group => $elements) {
            foreach (array_keys($elements) as $element) {
                if (in_array($element, $forbidden, true)) {
                    unset($GLOBALS['TL_CTE'][$group][$element]);
                }
            }

            if (empty($GLOBALS['TL_CTE'][$group])) {
                unset($GLOBALS['TL_CTE'][$group]);
            }
        }
    }
}

/**
 * complete list of content elements:
 * 
    texts → headline
    texts → html
    texts → list
    texts → text
    texts → code
    texts → description_list
    texts → markdown
    texts → table
    texts → unfiltered_html
    links → hyperlink
    links → toplink
    files → downloads
    files → download
    media → image
    media → gallery
    media → player
    media → youtube
    media → vimeo
    includes → article
    includes → alias
    includes → form
    includes → module
    includes → teaser
    includes → template
    legacy → accordionSingle
    legacy → accordionStart
    legacy → accordionStop
    legacy → sliderStart
    legacy → sliderStop
    dma_simplegrid → dma_simplegrid_wrapper_start
    dma_simplegrid → dma_simplegrid_wrapper_stop
    dma_simplegrid → dma_simplegrid_row_start
    dma_simplegrid → dma_simplegrid_row_stop
    dma_simplegrid → dma_simplegrid_column_start
    dma_simplegrid → dma_simplegrid_column_stop
    miscellaneous → accordion
    miscellaneous → element_group
    miscellaneous → swiper
    user → login
    user → manage_passkeys
    Theme-Elemente → rsce_cardBackground
    Theme-Elemente → rsce_cardSimple
    Theme-Elemente → rsce_factBlock
    Theme-Elemente → rsce_galleryLogos
    Theme-Elemente → rsce_heroSimple
    Theme-Elemente → rsce_iconBlock
    Theme-Elemente → rsce_iconList
    Theme-Elemente → rsce_teaserSimple
    Theme-Plugins → rsce_masonryGallery_start
    Theme-Plugins → rsce_masonryGallery_stop
    Theme-Plugins → rsce_sliderSlick_start
    Theme-Plugins → rsce_sliderSlick_stop
 */
