<?php

declare(strict_types=1);

namespace App\Theme;

use Contao\System;

/**
 * Liest die Theme-Version aus der composer.json
 */
final class DesignPlusVersion
{
    private const PACKAGE_NAME = 'think-digital.agency/contao-design-plus';

    public static function get(): string
    {
        $projectDir = System::getContainer()->getParameter('kernel.project_dir');
        $composerJson = $projectDir . '/composer.json';

        if (!is_file($composerJson)) {
            return 'unknown';
        }

        $json = json_decode(file_get_contents($composerJson), true);

        if (!is_array($json) || empty($json['version'])) {
            return 'unknown';
        }

        return (string) $json['version'];
    }
}
